<?php
/*
 * Elementor Varaus social Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_social extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_social';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('social', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-social-icons';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus social widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_social'];
	}

	/**
	 * Register Varaus social widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_social',
			[
				'label' => esc_html__('social Options', 'varaus-core'),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'ticon',
			[
				'label' => esc_html__('Themify Icon', 'varaus-core'),
				'type' => Controls_Manager::ICON,
				'options' => varaus_themify_icons(),
				'include' => varaus_include_themify_icons(),
				'default' => 'ti-facebook',
			]
		);
		$repeater->add_control(
			'social_link',
			[
				'label' => esc_html__('link', 'varaus-core'),
				'default' => esc_html__('#', 'varaus-core'),
				'placeholder' => esc_html__('Type your link here', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'socialItems_groups',
			[
				'label' => esc_html__('social Icons', 'varaus-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'social_link' => esc_html__('social', 'varaus-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ social_link }}}',
			]
		);
		$this->end_controls_section(); // end: Section


		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__('Icon', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_icon_typography',
				'selector' => '{{WRAPPER}} .social-shortcode .social-area ul a',
			]
		);
		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__('Icon Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-shortcode .social-area ul a i:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__('Backround Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .social-shortcode .social-area ul a' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


	}

	/**
	 * Render social widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$socialItems_groups = !empty($settings['socialItems_groups']) ? $settings['socialItems_groups'] : [];


		// Turn output buffer on
		ob_start(); ?>
		<div class="social-shortcode">
			<div class="social-area">
				<ul class="clearfix">
					<?php 	// Group Param Output
					if (is_array($socialItems_groups) && !empty($socialItems_groups)) {
						foreach ($socialItems_groups as $each_item) {

							$social_link = !empty($each_item['social_link']) ? $each_item['social_link'] : '';
							$social_icon = !empty($each_item['ticon']) ? $each_item['ticon'] : '';

							if ($social_icon) {
								echo '<li><a href="' . esc_url($social_link) . '"><i class="' . esc_attr($social_icon) . '"></i> <i class="fi "></i></a></li>';
							}
						}
					} ?>
				</ul>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render social widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_social());
