<?php
/*
 * Elementor Varaus Table Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_Table extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_table';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Table', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-price-table';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus Table widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_table'];
	}

	/**
	 * Register Varaus Table widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_table',
			[
				'label' => esc_html__('Table Options', 'varaus-core'),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'table_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'table_desc',
			[
				'label' => esc_html__('Desctription Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Desctription Text', 'varaus-core'),
				'placeholder' => esc_html__('Type Desctription text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'tableItem_groups',
			[
				'label' => esc_html__('Table Logos', 'varaus-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'table_title' => esc_html__('Table', 'varaus-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ table_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section


		// BG
		$this->start_controls_section(
			'section_table_bg_style',
			[
				'label' => esc_html__('BG', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'table_head_color',
			[
				'label' => esc_html__('Head BG Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-wrap th' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'table_td_color',
			[
				'label' => esc_html__('Head Row Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-wrap td' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'table_br_color',
			[
				'label' => esc_html__('Table Border Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-wrap td, .pricing-wrap th' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__('Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_title_typography',
				'selector' => '{{WRAPPER}} .pricing-wrap th',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-wrap th' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => __('Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .pricing-wrap th' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Sub Title
		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__('Sub Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_subtitle_typography',
				'selector' => '{{WRAPPER}} .pricing-wrap td',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pricing-wrap td' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'subtitle_padding',
			[
				'label' => __('Title Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .pricing-wrap td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

	}

	/**
	 * Render Table widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$tableItem_groups = !empty($settings['tableItem_groups']) ? $settings['tableItem_groups'] : [];

		// Turn output buffer on
		ob_start();
?>
		<table class="table-responsive pricing-wrap">
			<thead>
				<tr>
					<?php 	// Group Param Output
					if (is_array($tableItem_groups) && !empty($tableItem_groups)) {
						foreach ($tableItem_groups as $each_Item) {
							$table_title = !empty($each_Item['table_title']) ? $each_Item['table_title'] : '';

							if ($table_title) {
								echo '<th>' . esc_html($table_title) . '</th>';
							}
						}
					} ?>
				</tr>
			</thead>
			<tbody>
				<tr>
					<?php 	// Group Param Output
					if (is_array($tableItem_groups) && !empty($tableItem_groups)) {
						foreach ($tableItem_groups as $each_Item) {
							$table_desc = !empty($each_Item['table_desc']) ? $each_Item['table_desc'] : '';

							if ($table_desc) {
								echo '<td>' . esc_html($table_desc) . '</td>';
							}
						}
					} ?>
				</tr>
			</tbody>
		</table>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Table widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_Table());
