<?php
/*
 * Elementor Varaus Funfact Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_Funfact extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_funfact';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Funfact', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-counter';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus Funfact widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	public function get_script_depends()
	{
		return ['tmx-varaus_funfact'];
	}

	/**
	 * Register Varaus Funfact widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_funfact',
			[
				'label' => esc_html__('Funfact Options', 'varaus-core'),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'feature_icon',
			[
				'label' => __('Icon', 'varaus-core'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fi flaticon-pool',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'funfact_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'funfact_number',
			[
				'label' => esc_html__('Funfact Number', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('250', 'varaus-core'),
				'placeholder' => esc_html__('Type funfact Number here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'funfact_plus',
			[
				'label' => esc_html__('Funfact Plus/Percentage', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('+', 'varaus-core'),
				'placeholder' => esc_html__('Type funfact Plus/Percentage here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'funfactItems_groups',
			[
				'label' => esc_html__('Funfact Items', 'varaus-core'),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'funfact_title' => esc_html__('Funfact', 'varaus-core'),
					],

				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ funfact_title }}}',
			]
		);
		$this->end_controls_section(); // end: Section


		// Funfact Con
		$this->start_controls_section(
			'funfact_cions_style',
			[
				'label' => esc_html__('Number', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_cions_typography',
				'selector' => '{{WRAPPER}} .hx-counter-area .hx-counter-grids .hx-counter-icon i',
			]
		);
		$this->add_control(
			'cions_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid .fi:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'cions_padding',
			[
				'label' => __('Number Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid .fi' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Funfact Number
		$this->start_controls_section(
			'funfact_number_style',
			[
				'label' => esc_html__('Number', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'varaus_number_typography',
				'selector' => '{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid h2',
			]
		);
		$this->add_control(
			'number_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'number_padding',
			[
				'label' => __('Number Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		// Funfact Title
		$this->start_controls_section(
			'funfact_title_style',
			[
				'label' => esc_html__('Funfact Title', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'varaus-core'),
				'name' => 'ntrsvt_funfact_title_typography',
				'selector' => '{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid p',
			]
		);
		$this->add_control(
			'funfact_title',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_title_padding',
			[
				'label' => __('Number Padding', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .hx-counter-area .hx-counter-grids .grid p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section(); // end: Section


	}

	/**
	 * Render Funfact widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$funfactItems_groups = !empty($settings['funfactItems_groups']) ? $settings['funfactItems_groups'] : [];

		// Turn output buffer on
		ob_start();
?>
		<div class="hx-counter-area">
			<div class="hx-counter-grids">
				<?php 	// Group Param Output
				if (is_array($funfactItems_groups) && !empty($funfactItems_groups)) {
					foreach ($funfactItems_groups as $each_item) {

						$funfact_title = !empty($each_item['funfact_title']) ? $each_item['funfact_title'] : '';
						$funfact_number = !empty($each_item['funfact_number']) ? $each_item['funfact_number'] : '';
						$funfact_plus = !empty($each_item['funfact_plus']) ? $each_item['funfact_plus'] : '';

						$feature_icon = !empty($each_item['feature_icon']['value']) ? $each_item['feature_icon']['value'] : '';

						$feature_icon = !empty($each_item['feature_icon']['value']) ? $each_item['feature_icon']['value'] : '';
						$feature_svg_url = !empty($each_item['feature_icon']['value']['url']) ? $each_item['feature_icon']['value']['url'] : '';
						$svg_alt = get_post_meta($feature_svg_url, '_wp_attachment_image_alt', true);

				?>
						<div class="grid">
							<div class="hx-counter-icon">
								<?php
								if ($feature_svg_url) {
									echo '<img src="' . esc_url($feature_svg_url) . '" alt="' . esc_url($svg_alt) . '">';
								} else {
									echo '<i class="' . esc_attr($feature_icon) . '"></i>';
								}
								?>
							</div>
							<div>
								<?php if ($funfact_number) {
									echo '<h2><span class="odometer" data-count="' . esc_html($funfact_number) . '">' . esc_html__('00', 'varaus-core') . '</span>' . esc_html($funfact_plus) . '</h2>';
								} ?>
							</div>
							<?php if ($funfact_title) {
								echo '<p>' . wp_kses_post($funfact_title) . '</p>';
							} ?>
						</div>
				<?php }
				} ?>
			</div>
		</div>
<?php
		// Return outbut buffer
		echo ob_get_clean();
	}
	/**
	 * Render Funfact widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_Funfact());
