<?php
/*
 * Elementor Varaus Contact Form 7 Widget
 * Author & Copyright: wpoceans
*/

namespace Elementor;

if (!defined('ABSPATH')) exit; // Exit if accessed directly

class Varaus_Contact_Form extends Widget_Base
{

	/**
	 * Retrieve the widget name.
	 */
	public function get_name()
	{
		return 'tmx-varaus_contact_form';
	}

	/**
	 * Retrieve the widget title.
	 */
	public function get_title()
	{
		return esc_html__('Contact Form', 'varaus-core');
	}

	/**
	 * Retrieve the widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-form-horizontal';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 */
	public function get_categories()
	{
		return ['wpoceans-category'];
	}

	/**
	 * Retrieve the list of scripts the Varaus Contact Form widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	 */
	/*
	public function get_script_depends() {
		return ['tmx-varaus_contact_form'];
	}
	 */

	/**
	 * Register Varaus Contact Form widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'section_contact_form',
			[
				'label' => esc_html__('Form Options', 'varaus-core'),
			]
		);
		$this->add_control(
			'contact_title',
			[
				'label' => esc_html__('Title Text', 'varaus-core'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Title Text', 'varaus-core'),
				'placeholder' => esc_html__('Type title text here', 'varaus-core'),
				'label_block' => true,
			]
		);
		$this->add_control(
			'form_id',
			[
				'label' => esc_html__('Select contact form', 'varaus-core'),
				'type' => Controls_Manager::SELECT,
				'options' => Controls_Helper_Output::get_posts('wpcf7_contact_form'),
			]
		);
		$this->end_controls_section(); // end: Section



		$this->start_controls_section(
			'section_form_style',
			[
				'label' => esc_html__('Form', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'form_typography',
				'selector' => '{{WRAPPER}} .contact-content .contact-form input[type="text"], 
				{{WRAPPER}} .contact-content .contact-form input[type="email"], 
				{{WRAPPER}} .contact-content .contact-form input[type="date"], 
				{{WRAPPER}} .contact-content .contact-form input[type="time"], 
				{{WRAPPER}} .contact-content .contact-form input[type="number"], 
				{{WRAPPER}} .contact-content .contact-form textarea, 
				{{WRAPPER}} .contact-content .contact-form select, 
				{{WRAPPER}} .contact-content .contact-form .form-control, 
				{{WRAPPER}} .track-contact .track-trace select, 
				{{WRAPPER}} .track-contact .track-trace input',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'form_border',
				'label' => esc_html__('Border', 'varaus-core'),
				'selector' => '{{WRAPPER}} .contact-content .contact-form input[type="text"], 
				{{WRAPPER}} .contact-content .contact-form input[type="email"], 
				{{WRAPPER}} .contact-content .contact-forminput[type="date"], 
				{{WRAPPER}} .contact-content .contact-form input[type="time"], 
				{{WRAPPER}} .contact-content .contact-form input[type="number"], 
				{{WRAPPER}} .contact-content .contact-form textarea, 
				{{WRAPPER}} .contact-content .contact-form select, 
				{{WRAPPER}} .contact-content .contact-form .form-control, 
				{{WRAPPER}} .contact-content .contact-form .nice-select,
				{{WRAPPER}} .track-contact .track-trace select, 
				{{WRAPPER}} .track-contact .track-trace input',

			]
		);
		$this->add_control(
			'placeholder_text_color',
			[
				'label' => __('Placeholder Text Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form input:not([type="submit"])::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .contact-content .contact-form input:not([type="submit"])::-moz-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .contact-content .contact-form input:not([type="submit"])::-ms-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .contact-content .contact-form input:not([type="submit"])::-o-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .contact-content .contact-form textarea::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .contact-content .contact-form textarea::-moz-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .contact-content .contact-form textarea::-ms-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .contact-content .contact-form textarea::-o-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .track-contact .track-trace input::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .track-contact .track-trace select::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'label_color',
			[
				'label' => __('Label Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form label' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => __('Text Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form input[type="text"], 
					{{WRAPPER}} .contact-content .contact-form input[type="email"], 
					{{WRAPPER}} .contact-content .contact-form input[type="date"], 
					{{WRAPPER}} .contact-content .contact-form input[type="time"], 
					{{WRAPPER}} .contact-content .contact-form input[type="number"], 
					{{WRAPPER}} .contact-content .contact-form textarea, 
					{{WRAPPER}} .contact-content .contact-form select, 
					{{WRAPPER}} .contact-content .contact-form .form-control, 
					{{WRAPPER}} .track-contact .track-trace input, 
					{{WRAPPER}} .contact-content .contact-form .nice-select' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->end_controls_section(); // end: Section

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__('Button', 'varaus-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn',
			]
		);
		$this->add_responsive_control(
			'btn_width',
			[
				'label' => esc_html__('Width', 'varaus-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'btn_margin',
			[
				'label' => __('Margin', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'button_border_radius',
			[
				'label' => __('Border Radius', 'varaus-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->start_controls_tabs('button_style');
		$this->start_controls_tab(
			'button_normal',
			[
				'label' => esc_html__('Normal', 'varaus-core'),
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_bg_color',
			[
				'label' => esc_html__('Background Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'label' => esc_html__('Border', 'varaus-core'),
				'selector' => '{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit,.track-contact .track-trace .wpcf7-submit.submit-btn',
			]
		);
		$this->end_controls_tab();  // end:Normal tab

		$this->start_controls_tab(
			'button_hover',
			[
				'label' => esc_html__('Hover', 'varaus-core'),
			]
		);
		$this->add_control(
			'button_hover_color',
			[
				'label' => esc_html__('Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit:hover,.track-contact .track-trace .wpcf7-submit.submit-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'button_bg_hover_color',
			[
				'label' => esc_html__('Background Color', 'varaus-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit:hover,.track-contact .track-trace .wpcf7-submit.submit-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_hover_border',
				'label' => esc_html__('Border', 'varaus-core'),
				'selector' => '{{WRAPPER}} .contact-content .contact-form .wpcf7-form-control.wpcf7-submit:hover,.track-contact .track-trace .wpcf7-submit.submit-btn:hover',
			]
		);
		$this->end_controls_tab();  // end:Hover tab
		$this->end_controls_tabs(); // end tabs

		$this->end_controls_section(); // end: Section


	}

	/**
	 * Render Contact Form widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$form_id = !empty($settings['form_id']) ? $settings['form_id'] : '';
		$contact_title = !empty($settings['contact_title']) ? $settings['contact_title'] : '';

		// Turn output buffer on
		ob_start();
?>
		<div class="wpo-contact-page-section">
			<?php if ($contact_title) {
				echo '<h2>' . esc_html($contact_title) . '</h2>';
			} ?>
			<div class="contact-form">
				<?php echo do_shortcode('[contact-form-7 id="' . $form_id . '"]'); ?>
			</div>
		</div>
<?php

		// Return outbut buffer
		echo ob_get_clean();
	}



	/**
	 * Render Contact Form widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 */

	//protected function _content_template(){}

}
Plugin::instance()->widgets_manager->register(new Varaus_Contact_Form());
