/*
Template Name: Varaus
Author: wpoceans
Version: 1.0
*/

(function ($) {
  "use strict";

  /*----- ELEMENTOR LOAD FUNTION CALL ---*/

  $(window).on("elementor/frontend/init", function () {
    var hero_slide = function () {
      // Hero slider background setting
      function sliderBgSetting() {
        if ($(".hero-slider .slide").length) {
          $(".hero-slider .slide").each(function () {
            var $this = $(this);
            var img = $this.find(".slider-bg").attr("src");

            $this.css({
              backgroundImage: "url(" + img + ")",
              backgroundSize: "cover",
              backgroundPosition: "center center",
            });
          });
        }
      }

      sliderBgSetting();

      //Setting hero slider
      function heroSlider() {
        if ($(".hero-slider").length) {
          $(".hero-slider").not(".slick-initialized").slick({
            autoplay: true,
            autoplaySpeed: 8000,
            arrows: true,
            prevArrow:
              '<button type="button" class="slick-prev">Previous</button>',
            nextArrow: '<button type="button" class="slick-next">Next</button>',
            dots: true,
            fade: true,
            cssEase: "linear",
          });
        }
      }

      //Active heor slider
      heroSlider();
    }; // end

    var gallery_filters = function () {
      /*------------------------------------------
        = FUNCTION FORM SORTING GALLERY
        -------------------------------------------*/
      function sortingGallery() {
        if ($(".sortable-gallery .gallery-filters").length) {
          var $container = $(".gallery-container");
          $container.isotope({
            filter: "*",
            animationOptions: {
              duration: 750,
              easing: "linear",
              queue: false,
            },
          });

          $(".gallery-filters li a").on("click", function () {
            $(".gallery-filters li .current").removeClass("current");
            $(this).addClass("current");
            var selector = $(this).attr("data-filter");
            $container.isotope({
              filter: selector,
              animationOptions: {
                duration: 750,
                easing: "linear",
                queue: false,
              },
            });
            return false;
          });
        }
      }

      sortingGallery();
    }; // end

    var testimonials_slider = function () {
      /*------------------------------------------
        = TESTIMONIALS SLIDER
        -------------------------------------------*/
      if ($(".testimonial-slider".length)) {
        $(".testimonial-slider").owlCarousel({
          mouseDrag: false,
          smartSpeed: 1500,
          margin: 30,
          autoplay: true,
          loop: true,
          nav: false,
          dots: false,
          items: 3,
          responsive: {
            0: {
              items: 1,
            },

            650: {
              items: 1,
            },

            768: {
              items: 2,
            },

            992: {
              items: 3,
            },
          },
        });
      }
    }; // end

    var odometer = function () {
      /*------------------------------------------
        = FUNFACT
        -------------------------------------------*/
      if ($(".odometer").length) {
        $(".odometer").appear();
        $(document.body).on("appear", ".odometer", function (e) {
          var odo = $(".odometer");
          odo.each(function () {
            var countNumber = $(this).attr("data-count");
            $(this).html(countNumber);
          });
        });
      }
    }; // end

    var partners_slider = function () {
      /*------------------------------------------
        = PARTNERS SLIDER
        -------------------------------------------*/
      if ($(".partners-slider").length) {
        $(".partners-slider").owlCarousel({
          autoplay: true,
          smartSpeed: 300,
          margin: 30,
          loop: true,
          autoplayHoverPause: true,
          dots: false,
          responsive: {
            0: {
              items: 2,
            },

            550: {
              items: 3,
            },

            992: {
              items: 4,
            },

            1200: {
              items: 5,
            },
          },
        });
      }
    }; // end

    var destination = function () {
      /*------------------------------------------
        destination-carousel
    -------------------------------------------*/
      if ($(".destination-carousel".length)) {
        $(".destination-carousel").owlCarousel({
          loop: !0,
          autoplaySpeed: 3e3,
          navSpeed: 3e3,
          paginationSpeed: 3e3,
          slideSpeed: 3e3,
          smartSpeed: 3e3,
          autoplay: 3e3,
          margin: 30,
          nav: false,
          dots: !1,
          responsive: {
            0: { items: 1 },
            480: { items: 1 },
            600: { items: 2 },
            1024: { items: 2 },
            1200: { items: 3 },
          },
        });
      }
    }; // end

    var VarusSortingGallery = function () {
      /*------------------------------------------
            = FUNCTION FORM SORTING GALLERY
        -------------------------------------------*/
      function sortingGallery() {
        if ($(".sortable-gallery .gallery-filters").length) {
          var $container = $(".gallery-container");
          $container.isotope({
            filter: "*",
            animationOptions: {
              duration: 750,
              easing: "linear",
              queue: false,
            },
          });

          $(".gallery-filters li a").on("click", function () {
            $(".gallery-filters li .current").removeClass("current");
            $(this).addClass("current");
            var selector = $(this).attr("data-filter");
            $container.isotope({
              filter: selector,
              animationOptions: {
                duration: 750,
                easing: "linear",
                queue: false,
              },
            });
            return false;
          });
        }
      }

      sortingGallery();
    }; // end

    //hero_slide
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/tmx-varaus_slider.default",
      function ($scope, $) {
        hero_slide();
      }
    );

    //tmx-varaus_banner
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/tmx-varaus_banner.default",
      function ($scope, $) {
        hero_slide();
      }
    );

    //testimonial
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/tmx-varaus_testimonial.default",
      function ($scope, $) {
        testimonials_slider();
      }
    );

    //odometer
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/tmx-varaus_funfact.default",
      function ($scope, $) {
        odometer();
      }
    );

    //partners_slider
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/tmx-varaus_client.default",
      function ($scope, $) {
        partners_slider();
      }
    );

    //destination
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/tmx-varaus_destination.default",
      function ($scope, $) {
        destination();
      }
    );

    //destination
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/wpo_varaus_room_filter.default",
      function ($scope, $) {
        VarusSortingGallery();
      }
    );
  });
})(jQuery);
